// Study of Free Space Propagation-Path Loss Model (FSPL)
// OS - Windows 10
// Scilab 6.1.0
// Course Instructor Name: Dr. V. A. Sankar Ponnapalli
// Institute Name: ICFAI Foundation for Higher Education Hyderabad

clc;
clear;
close();

disp("Enter frequency in Hz (Recommended: 800e6 to 2.5e9):");
f = input("Frequency (Hz): ");

disp("Enter minimum distance in meters (Recommended: 1 to 10 m):");
d_min = input("Minimum distance (m): ");

disp("Enter maximum distance in meters (Recommended: 100 to 10000 m):");
d_max = input("Maximum distance (m): ");

disp("Enter number of distance samples (Recommended: 50 to 500):");
n = input("Number of points: ");

c = 3e8; // Speed of light in m/s
lambda = c / f; // Wavelength in meters
d = linspace(d_min, d_max, n);

// Compute Free Space Path Loss (FSPL)
path_loss = 20*log10(d) + 20*log10(f) + 20*log10(4 * %pi / c);

scf();
plot(d, path_loss, 'r', 'LineWidth', 2);
xlabel('Distance (m)');
ylabel('Path Loss (dB)');
title('FSPL Model: Distance vs Path Loss');
h = gca();
h.grid = [1 1]; // Turn on both axes grid

// Description of the Figure
// User Inputs:
// Enter frequency in Hz (Recommended: 800e6 to 2.5e9):
// Frequency (Hz): 900e6
// Enter minimum distance in meters (Recommended: 1 to 10 m):
// Minimum distance (m): 5
// Enter maximum distance in meters (Recommended: 100 to 10000 m):
// Maximum distance (m): 500
// Enter number of distance samples (Recommended: 50 to 500):
// Number of points: 50

// The figure titled "Interactive FSPL Model: Distance vs Path Loss" illustrates how free space path loss (in dB)
// increases logarithmically with distance in a line-of-sight communication environment.









